#===============================================================#
#                                                               #
#             PerlBill - Client Management Software             #
#                                                               #
#================================================================
# PerlBill System Level OPTIONS                                 #
#===============================================================#

# Enable cPanel Integration
#    1 = Yes
#    0 = No

     $USE_CPANEL    = 0;

# After enabling you will need to login to the admin and enter the
# cPanel details in the Settings section


#========================================================================
# Gateway Integration
#
# If you enable authorize.net and choose to store credit card
# numbers it is entirely at your own risk. Storing your clients
# credit card numbers is a risk and not recommended.

    $Authorize_Net = 1;


#========================================================================
# OPERATING SYSTEM

 $WIN = "0";

 # Is this a windows machine?  1= YES 0 = NO
 # If you are using WINDOWS PLEASE INSTALL DBD::mysqlPP

#========================================================================


 # These are the file extensions that wil be allowed for upload 
 #
            %file_types = (
                             txt   => "1",
                             gif   => "1",
                             html  => "1",
                             htm   => "1",
                             jpg   => "1", 
                             jpeg  => "1",
                             png   => "1",
                             bmp   => "1"     
                        );


#================================================================================#
# Please do NOT edit any further, doing so may prevent areas of your installation 
# functioning properly.


  $REVISION       =  "2.0"; 
  $IS_PRO         =  $Authorize_Net;
  $CF_auto_charge =  "1";
  $enablemail     =   1;    # Setting to '0' will disable all outgoing e-mail from perlbill


#~~
# Error Page
#~~

 sub die_nice 
  {
      my $error = "@_";

      print "Content-type: text/html\n\n";
 
      print qq|
                 <html><head><title>$global{'title'}: Error</title><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
                 </head><body bgcolor="#FFFFFF"><p>&nbsp;</p><table width="496" border="0" cellspacing="0" cellpadding="0" align="center"><tr><td colspan="3"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>$global{'title'}: 
                 <font color="#990000"> Error</font></b></font></td></tr><tr><td colspan="3" height="11">&nbsp;</td></tr><tr><td colspan="3" height="6"><font face="Courier New, Courier, mono" size="2">$error</font></td></tr><tr> <td colspan="3" height="2">&nbsp;</td></tr><tr> <td colspan="3" height="40"> <table width="60%" border="0" cellspacing="0" cellpadding="0" align="center"> <tr> <td width="50%"><b><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><a href="javascript:history.back(1)">BACK</a></font></b></td><td width="50%"><div align="right"><b><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=login">LOGIN</a></font></b></div></td></tr></table></td></tr></table><p align="center">&nbsp;</p></body></html>
              |;
     exit; 
 }

#~~
# Third Party Templates
#~~

sub display_tparty
 {
    my $provider = "@_";   

       open(TPL, "$global{'data'}/include/tpl/gateways/$provider.txt");
            while (<TPL>) 
                {  
                    s/(\$[a-zA-Z0-9\{\'\}_]+)/ eval ($1) /ge;
                    $template{'tparty'} .= $_;   
                }
       close(TPL); 
 }


#~~
# Send Email
#~~

 sub email
  {
     my %contact = @_;

     if ($enablemail == "1")
       {

         if (get_setting_2("use_smtp"))
          {
             use Mail::Sender;
  
              my $smtp_address  = get_setting_2("smtp_address");
              my $smtp_username = get_setting_2("smtp_username");
              my $smtp_password = get_setting_2("smtp_password");

                 $sender = new Mail::Sender
	 	   {
                       smtp => $smtp_address, 
                       from => $contact{'From'}
                   };

	 	  $sender->MailMsg(
                   {
                      to      => $contact{'To'},
		      subject => $contact{'Subject'},
	 	      msg     => $contact{'Body'}
                   });
  
 
                 $sender->Close;


          }
            else {
                    open(MAIL, "|$global{'sendmail'} -t") || die "Unable to send mail: $!";
                         print MAIL "To: $contact{'To'}\n";
                         print MAIL "From: $contact{'From'}\n";
                         print MAIL "Subject: $contact{'Subject'}\n\n";
                         print MAIL "$contact{'Body'}\n";
                    close(MAIL);
                  }


       }
   }

#~~
# Ticket coding
#~~

sub pdcode 
 {
      my $text = "@_";

         $text =~ s/\[b\]/<b>/gi;
         $text =~ s/\[\/b\]/<\/b>/gi;
         $text =~ s/\[i\]/<i>/gi;
         $text =~ s/\[\/i\]/<\/i>/gi;

         return $text;  
 }


#~~
# System Script Error 
#~~

 sub script_error 
  {

     my $error = "@_";

     print "Content-type: text/html\n\n";
 
     print qq~<html><head><title>PerlBill Error</title>
              <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
              </head><body bgcolor="#FFFFFF"><p>&nbsp;</p><table width="600" border="0" cellspacing="0" cellpadding="0" align="center"><tr><td colspan="3"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>PerlBill: <font color="#990000">Script Error</font></b></font></td></tr><tr> <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr> <td colspan="3"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Perlbill was unable to launch due to the following errors:</font></td>
              </tr><tr><td colspan="3" height="40"><font face="Courier New, Courier, mono" size="2"><br>$error<br><br><br><Br><div align=center>[ <a href="http://perlbill.com">PerlBill Site</a> ]</font></td></tr></table><p align="center">&nbsp;</p></body></html>
             ~;
     exit;
  }

#~~
# Execute SQL Statement
#~~

 sub execute_sql 
  {
        my $sql = "@_";
 	my $tatement = qq|$sql|; 
        my $sth = $dbh->prepare($tatement) or die "Couldn't prepare statement: $DBI::errstr; stopped";
           $sth->execute() or die "Couldn't execute statement: $DBI::errstr; stopped";
           $sth->finish;
  }

 sub get_setting 
  {
        my $sql = "@_"; 
        my $value;

     my $statement = 'SELECT * FROM settings WHERE setting = ?'; 
     my $sth       = $dbh->prepare($statement) or die "Couldn't prepare statement: $DBI::errstr; stopped";
        $sth->execute( $sql ) or die "Couldn't execute statement: $DBI::errstr; stopped";
          while(my $ref = $sth->fetchrow_hashref()) 
            { 
                 $value = $ref->{'value'};
            }  
         $sth->finish;

    return $value;
 
  }

 sub get_setting_2 
  {
        my $sql = "@_"; 
        my $value;

     my $statement = 'SELECT * FROM settings_extra WHERE setting = ?'; 
     my $sth       = $dbh->prepare($statement) or die "Couldn't prepare statement: $DBI::errstr; stopped";
        $sth->execute( $sql ) or die "Couldn't execute statement: $DBI::errstr; stopped";
          while(my $ref = $sth->fetchrow_hashref()) 
            { 
                 $value = $ref->{'value'};
            }  
         $sth->finish;

    return $value;
 
  }


 sub redirect 
  {
      my $url = "@_";

     	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="1;URL=$url"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Thank You</b>, you are now being re-directed.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$url">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;
  }



sub notify_techs 
 {

    my %details = @_;

   $statement = 'SELECT * FROM calls WHERE id = ?'; 
   $sth = $dbh->prepare($statement) or die "Couldn't prepare statement: $DBI::errstr; stopped";
   $sth->execute( $details{'tid'} ) or die "Couldn't execute statement: $DBI::errstr; stopped";
   $number = 0;
      while(my $ref = $sth->fetchrow_hashref()) 
         {	
	     $category    =  $ref->{'category'};
         }

        $statement = qq|SELECT * FROM staff WHERE access LIKE "%$category::%" OR access LIKE "%GLOB::%" OR access="admin"|;
        $sth       = $dbh->prepare($statement)or die "Couldn't prepare statement: $DBI::errstr; stopped";
        $sth->execute() or die "Couldn't execute statement: $DBI::errstr; stopped";
         while(my $ref = $sth->fetchrow_hashref()) {
		if ($ref->{'notify'} == "1")
                  {
                     if ($enablemail) 
                      {
				$body .= "There is a new help desk response made by '$details{'name'}' in request $details{'tid'}\n";
				$body .=  "\nCall Details\n";
				$body .=  "---------------------------------------\n";
				$body .=  "\tResponse by......: $details{'name'}  \n";
				$body .=  "\tTime.............: $details{'time'}  \n"; 
				$body .=  "\t$details{'note'}                     \n";
				$body .=  "---------------------------------------\n$global{'baseurl'}/staff.cgi?do=ticket&cid=$details{'tid'}\n";
				$body .=  "\n\nThank You.";
			
                                email( To => "$ref->{'email'}", From => "$global{'adminemail'}", Subject => "User Response ", Body => "$body");
 	              } 
                  }
	  }
            $sth->finish;
   }


@languages = ("en", "sw", "no", "es", "fr", "gm");

# en -> English
# sw -> Swedish
# es -> Spanish
# no -> Norweigan


%langdetails = 
  (
       en     =>   "English",
       sw     =>   "Swedish",
       no     =>   "Norwegian",
       es     =>   "Spanish",
       fr     =>   "French",
       gm     =>   "German"
  );

# You can leave the above as it is, unless you need to 
# remove or add any languages - in which case you must 
# edit both @languages and %langdetails

$enablelang = 1;   

sub get_data
 {
    my $sql = "@_";
 
	my $sth = $dbh->prepare($sql);
	   $sth->execute();
	while(my $ref = $sth->fetchrow_hashref()) 
	  {
               for (keys %$ref) {
                                  $template{$_} = $ref->{$_};
                                }
  	  }
 }

###############################################################
# GLOBAL DATE AND TIME


sub get_time {

   $global{'timeoffset'} = "0" if !$global{'timeoffset'};

 my $timeoffset = $global{'timeoffset'};
 my @days   = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
 my @months = ('January','February','March','April','May','June','July','August','September','October','November','December');   
     ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time + (3600*$timeoffset));
	   	$hour = "0$hour" if ($hour < 10);
		$min  = "0$min" if ($min < 10);
		$sec  = "0$sec" if ($sec < 10);
      if ($hour >= 12) { $variable = "P.M."; }
            else { $variable  = "A.M."; }
      if ($hour == 0) { $hour = 12; }
      if ($hour > 12) { $hour -= 12; }
          $year = 1900 + $year;
	if ($mday eq "1") {       $hy = "st"; 
	} elsif ($mday eq "21") { $hy = "st";
	} elsif ($mday eq "31") { $hy = "st"; 
	} elsif ($mday eq "2")  { $hy = "nd";
	} elsif ($mday eq "22") { $hy = "nd"; 
	} elsif ($mday eq "3")  { $hy = "rd"; 
	} elsif ($mday eq "23") { $hy = "rd";
	} else { $hy = "th"; }
     		   $day = $days[$wday];
		   $month    = $months[$mon];
		   $month_no = ++$mon;
		my $date     = "$mday$hy";
	           $date_no  =  $mday;
		   $time     = "$hour:$min:$sec $variable";
		   $time_sv  = "$hour:$min $variable";
		   $time_var = "$hour:$min:$sec";
		   $time_sec = "$hour:$min";

       $hdtime  = "$date_no/$month_no/$year $time_sv" if $global{'timeformat'} eq "uk";
       $timenow = "$time ($date_no/$month_no/$year)"  if $global{'timeformat'} eq "uk";
       $hdtime  = "$month_no/$date_no/$year $time_sv" if $global{'timeformat'} eq "us";
       $timenow = "$time ($month_no/$date_no/$year)"  if $global{'timeformat'} eq "us";

 }


       $date                      =  Class::Date->new;
       $Class::Date::DATE_FORMAT  =  "%m/%d/%Y";
       $date                      =  now; 





1;
