  use lib '/usr/local/cpanel';
  use Cpanel::Accounting;

sub vars 
 {
  
   $whm               =  Cpanel::Accounting->new;
   $whm->{host}       =  $cpanel{'host'};
   $whm->{user}       =  $cpanel{'username'}; 
   $whm->{usessl}     =  0;
   $whm->{accesshash} =  get_cpanel_key();
 }


 sub get_cpanel_key 
  {

     my $server = get_setting_2(qq|cpanel_server|);
     my $statement = qq|SELECT ckey FROM cpanel WHERE id = "$server"|; 
     my $sth       = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
        $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
      while(my $ref = $sth->fetchrow_hashref()) 
         {
                 $key = "$ref->{'ckey'}";
         } 
        $sth->finish;
        return $key;
  }


sub cpget_list 
 {
     vars();

     %PKGS = $whm->listpkgs();

     foreach $package (sort keys %PKGS) 
      {
           $template{'accounts'} .= qq|<option value=$package>$package</option>|;
      } 
 }


sub suspend_cpanel 
 {  
     my $username = "@_";
     vars();

     $response = $whm->suspend("$username");

    if ($whm->{error} ne "") { die_nice("There was an error while processing your request: $whm->{error}\n"); }       

 }

sub unsuspend_cpanel 
 {  
     my $username = "@_";
     vars();

     $response = $whm->unsuspend("$username");

    if ($whm->{error} ne "") { die_nice("There was an error while processing your request: $whm->{error}\n"); }       
 }

sub kill_cpanel 
 {  
     my $username = "@_";
     vars();

     $response = $whm->killacct("$username");

    if ($whm->{error} ne "") { die_nice("There was an error while processing your request: $whm->{error}\n"); }       

 }


sub create_cpanel_acc
 {
    vars();

    my %cp_details = @_;
    $response   =  $whm->createacct("$cp_details{'domain'}","$cp_details{'username'}","$cp_details{'password'}","$cp_details{'package'}");

    if ($whm->{error} ne "") { die_nice("There was an error while processing your request: $whm->{error}\n"); }       
 }


1;